//===========================================================================
//
//      strcpy.cxx
//
//      ANSI standard strcpy() routine
//
//===========================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//                                                                          
//####COPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       
//
//####DESCRIPTIONEND####
//
//===========================================================================

// CONFIGURATION

#include <pkgconf/libc.h>   // Configuration header

// Include the C library?
#ifdef CYGPKG_LIBC     

// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions
#include <cyg/infra/cyg_trac.h>    // Tracing support
#include <cyg/infra/cyg_ass.h>     // Assertion support
#include <string.h>                // Header for this file
#include <stddef.h>          // Compiler definitions such as size_t, NULL etc.
#include "clibincl/stringsupp.hxx"  // Useful string function support and
                                    // prototypes

// EXPORTED SYMBOLS

externC char *
strcpy( char *s1, const char *s2 ) CYGPRI_LIBC_WEAK_ALIAS("_strcpy");

// FUNCTIONS

char *
_strcpy( char *s1, const char *s2 )
{
    CYG_REPORT_FUNCNAMETYPE( "_strcpy", "returning addr %08x" );
    CYG_REPORT_FUNCARG2( "s1=%08x, s2=%08x", s1, s2 );

    CYG_CHECK_DATA_PTR( s1, "s1 is not a valid pointer!" );
    CYG_CHECK_DATA_PTR( s2, "s2 is not a valid pointer!" );

#if defined(CYGIMP_LIBC_STRING_PREFER_SMALL_TO_FAST) || defined(__OPTIMIZE_SIZE__)
    char *s = s1;
    
    while ((*s1++ = *s2++) != '\0')
        ;

    CYG_REPORT_RETVAL( s );
    
    return s;
#else
    char *dst = s1;
    const char *src = s2;
    CYG_WORD *aligned_dst;
    const CYG_WORD *aligned_src;
    
    // If SRC or DEST is unaligned, then copy bytes.
    if (CYG_LIBC_STR_UNALIGNED2 (src, dst))
    {
        while ((*dst++ = *src++) != '\0')
            ;

        CYG_REPORT_RETVAL( s1 );
    
        return s1;
    }
    
    aligned_dst = (CYG_WORD *)dst;
    aligned_src = (const CYG_WORD *)src;
    
    // SRC and DEST are both "CYG_WORD" aligned, try to do "CYG_WORD"
    // sized copies.
    while (!CYG_LIBC_STR_DETECTNULL(*aligned_src))
    {
        *aligned_dst++ = *aligned_src++;
    }
    
    dst = (char*)aligned_dst;
    src = (char*)aligned_src;
    
    while ((*dst++ = *src++) != '\0')
           ;

    CYG_REPORT_RETVAL( s1 );
    
    return s1;
#endif // not defined(CYGIMP_LIBC_STRING_PREFER_SMALL_TO_FAST) ||
       //     defined(__OPTIMIZE_SIZE__)
} // _strcpy()

#endif // ifdef CYGPKG_LIBC     

// EOF strcpy.cxx
