/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.jdbc2.Connection;
import org.postgresql.jdbc2.ResultSet;
import org.postgresql.util.PSQLException;

public class Array
implements java.sql.Array {
    private org.postgresql.Connection conn = null;
    private Field field = null;
    private ResultSet rs = null;
    private int idx = 0;
    private String rawString = null;

    public Array(org.postgresql.Connection connection, int n, Field field, ResultSet resultSet) throws SQLException {
        this.conn = connection;
        this.field = field;
        this.rs = resultSet;
        this.idx = n;
        this.rawString = resultSet.getFixedString(n);
    }

    public Object getArray() throws SQLException {
        return this.getArray(1L, 0, (Map)null);
    }

    public Object getArray(long l, int n) throws SQLException {
        return this.getArray(l, n, (Map)null);
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        Object[] objectArray;
        if (map != null) {
            throw Driver.notImplemented();
        }
        if (l < 1L) {
            throw new PSQLException("postgresql.arr.range");
        }
        Object[] objectArray2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.rawString != null) {
            objectArray = this.rawString.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] == '{') {
                    if (bl) {
                        throw Driver.notImplemented();
                    }
                    bl = true;
                } else if (objectArray[n2] == '\"') {
                    bl2 ^= true;
                } else if (!bl2 && objectArray[n2] == ',' || objectArray[n2] == '}' || n2 == objectArray.length - 1) {
                    if (objectArray[n2] != '\"' && objectArray[n2] != '}' && objectArray[n2] != ',') {
                        stringBuffer.append(objectArray[n2]);
                    }
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(objectArray[n2]);
                }
                ++n2;
            }
        }
        objectArray = arrayList.toArray(new String[arrayList.size()]);
        if (n == 0) {
            n = objectArray.length;
        }
        if (--l + (long)n > (long)objectArray.length) {
            throw new PSQLException("postgresql.arr.range");
        }
        int n3 = 0;
        switch (this.getBaseType()) {
            case -7: {
                objectArray2 = new boolean[n];
                while (n > 0) {
                    objectArray2[n3++] = ResultSet.toBoolean((String)objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = new int[n];
                while (n > 0) {
                    ((int[])objectArray2)[n3++] = ResultSet.toInt((String)objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case -5: {
                objectArray2 = new long[n];
                while (n > 0) {
                    ((long[])objectArray2)[n3++] = ResultSet.toLong((String)objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 2: {
                objectArray2 = new BigDecimal[n];
                while (n > 0) {
                    ((BigDecimal[])objectArray2)[n3] = ResultSet.toBigDecimal((String)objectArray[(int)l++], 0);
                    --n;
                }
                break;
            }
            case 7: {
                objectArray2 = new float[n];
                while (n > 0) {
                    ((float[])objectArray2)[n3++] = ResultSet.toFloat((String)objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 8: {
                objectArray2 = new double[n];
                while (n > 0) {
                    ((double[])objectArray2)[n3++] = ResultSet.toDouble((String)objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = new String[n];
                while (n > 0) {
                    ((String[])objectArray2)[n3++] = (String)objectArray[(int)l++];
                    --n;
                }
                break;
            }
            case 91: {
                objectArray2 = new Date[n];
                while (n > 0) {
                    ((Date[])objectArray2)[n3++] = ResultSet.toDate((String)objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 92: {
                objectArray2 = new Time[n];
                while (n > 0) {
                    ((Time[])objectArray2)[n3++] = ResultSet.toTime((String)objectArray[(int)l++]);
                    --n;
                }
                break;
            }
            case 93: {
                objectArray2 = new Timestamp[n];
                Object var9_10 = null;
                while (n > 0) {
                    ((Timestamp[])objectArray2)[n3++] = ResultSet.toTimestamp((String)objectArray[(int)l], this.rs);
                    --n;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return objectArray2;
    }

    public Object getArray(Map map) throws SQLException {
        return this.getArray(1L, 0, map);
    }

    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        String string = this.field.getPGType();
        if (string.charAt(0) == '_') {
            string = string.substring(1);
        }
        return string;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, 0, (Map)null);
    }

    public java.sql.ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, (Map)null);
    }

    public java.sql.ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        Object object = this.getArray(l, n, map);
        Vector<byte[][]> vector = new Vector<byte[][]>();
        Field[] fieldArray = new Field[2];
        fieldArray[0] = new Field(this.conn, "INDEX", this.conn.getOID("int2"), 2);
        switch (this.getBaseType()) {
            case -7: {
                boolean[] blArray = (boolean[])object;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("bool"), 1);
                int n2 = 0;
                while (n2 < blArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n2));
                    byArray[1] = this.conn.getEncoding().encode(blArray[n2] ? "YES" : "NO");
                    vector.addElement(byArray);
                    ++n2;
                }
            }
            case 5: {
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("int2"), 2);
            }
            case 4: {
                int[] nArray = (int[])object;
                if (fieldArray[1] == null) {
                    fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("int4"), 4);
                }
                int n3 = 0;
                while (n3 < nArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n3));
                    byArray[1] = this.conn.getEncoding().encode(Integer.toString(nArray[n3]));
                    vector.addElement(byArray);
                    ++n3;
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])object;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("int8"), 8);
                int n4 = 0;
                while (n4 < lArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n4));
                    byArray[1] = this.conn.getEncoding().encode(Long.toString(lArray[n4]));
                    vector.addElement(byArray);
                    ++n4;
                }
                break;
            }
            case 2: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("numeric"), -1);
                int n5 = 0;
                while (n5 < bigDecimalArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n5));
                    byArray[1] = this.conn.getEncoding().encode(bigDecimalArray[n5].toString());
                    vector.addElement(byArray);
                    ++n5;
                }
                break;
            }
            case 7: {
                float[] fArray = (float[])object;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("float4"), 4);
                int n6 = 0;
                while (n6 < fArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n6));
                    byArray[1] = this.conn.getEncoding().encode(Float.toString(fArray[n6]));
                    vector.addElement(byArray);
                    ++n6;
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])object;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("float8"), 8);
                int n7 = 0;
                while (n7 < dArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n7));
                    byArray[1] = this.conn.getEncoding().encode(Double.toString(dArray[n7]));
                    vector.addElement(byArray);
                    ++n7;
                }
                break;
            }
            case 1: {
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("char"), 1);
            }
            case 12: {
                String[] stringArray = (String[])object;
                if (fieldArray[1] == null) {
                    fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("varchar"), -1);
                }
                int n8 = 0;
                while (n8 < stringArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n8));
                    byArray[1] = this.conn.getEncoding().encode(stringArray[n8]);
                    vector.addElement(byArray);
                    ++n8;
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])object;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("date"), 4);
                int n9 = 0;
                while (n9 < dateArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n9));
                    byArray[1] = this.conn.getEncoding().encode(dateArray[n9].toString());
                    vector.addElement(byArray);
                    ++n9;
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])object;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("time"), 8);
                int n10 = 0;
                while (n10 < timeArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n10));
                    byArray[1] = this.conn.getEncoding().encode(timeArray[n10].toString());
                    vector.addElement(byArray);
                    ++n10;
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])object;
                fieldArray[1] = new Field(this.conn, "VALUE", this.conn.getOID("timestamp"), 8);
                int n11 = 0;
                while (n11 < timestampArray.length) {
                    byte[][] byArray = new byte[2][0];
                    byArray[0] = this.conn.getEncoding().encode(Integer.toString((int)l + n11));
                    byArray[1] = this.conn.getEncoding().encode(timestampArray[n11].toString());
                    vector.addElement(byArray);
                    ++n11;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return new ResultSet((Connection)this.conn, fieldArray, vector, "OK", 1);
    }

    public java.sql.ResultSet getResultSet(Map map) throws SQLException {
        return this.getResultSet(1L, 0, map);
    }

    public String toString() {
        return this.rawString;
    }
}

