﻿using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;
using System.Configuration;
using System.Text;

namespace fb2pg
{
    /// <summary>
    /// Esta clase gestiona los índices de las tablas de la base de datos Firebird.
    /// </summary>
    class TablasIndices
    {
        #region · Campos ·

        /// <summary>
        /// Nombre de la tabla
        /// </summary>
        string tabla;
        /// <summary>
        /// Nombre de la tabla
        /// </summary>
        public string Tabla
        {
            get { return tabla; }
            set { tabla = value; }
        }

        /// <summary>
        /// Nombre del índice
        /// </summary>
        string nombreIndice;
        /// <summary>
        /// Nombre del índice
        /// </summary>
        public string NombreIndice
        {
            get { return nombreIndice; }
            set { nombreIndice = value; }
        }

        /// <summary>
        /// Lista de campos, separados por comas, que componen el índice
        /// </summary>
        string campos;
        /// <summary>
        /// Lista de campos, separados por comas, que componen el índice
        /// </summary>
        public string Campos
        {
            get { return campos; }
            set { campos = value; }
        }

        /// <summary>
        /// Indica si el índice es de tipo UNIQUE
        /// </summary>
        bool unico;
        /// <summary>
        /// Indica si el índice es de tipo UNIQUE
        /// </summary>
        public bool Unico
        {
            get { return unico; }
            set { unico = value; }
        }

        #endregion

        #region · Constructor ·

        /// <summary>
        /// Crea uns instancia de la clase <see cref="TablasIndices"/>
        /// </summary>
        /// <param name="t">Nombre de la tabla</param>
        /// <param name="n">Nombre del índice</param>
        /// <param name="c">Nombre de los campos</param>
        /// <param name="u">Indica si el índice es de tipo UNIQUE</param>
        public TablasIndices(string t, string n, string c, bool u)
        {
            this.tabla = t.ToLowerInvariant();
            this.nombreIndice = n.ToLowerInvariant();
            this.campos = c.ToLowerInvariant();
            this.unico = u;
        }

        #endregion

        #region · Método estático ·

        /// <summary>
        /// Rellena una lista de objetos <see cref="TablasIndices"/> con los índices definidos en la base de datos Firebird
        /// </summary>
        /// <param name="conn">Conexión con la base de datos Firebird</param>
        /// <param name="lista">Lista de objetos <see cref="TablasIndices"/> que vamos a rellenar</param>
        public static void RellenaListaTablasIndices(DbConnection conn, List<TablasIndices> lista)
        {
            if (conn == null || lista == null)
                return;

            DataTable dtIndices = conn.GetSchema("Indexes");

            DataTable dtNombresCampos = new DataTable();

            using (DbCommand cmd = conn.CreateCommand())
            {
                cmd.CommandText = "SELECT * FROM rdb$index_segments ORDER BY rdb$index_name,rdb$field_position";
                dtNombresCampos.Load(cmd.ExecuteReader());
            }

            int numFilas = dtIndices.Rows.Count;
            int numCampos = dtNombresCampos.Rows.Count;

            for (int nLin = 0; nLin < numFilas; nLin++)
            {
                DataRow row = dtIndices.Rows[nLin];

                if (Convert.ToInt32(row["IS_SYSTEM_INDEX"].ToString()) == 0 &&
                    Convert.ToInt32(row["IS_INACTIVE"].ToString()) == 0 &&
                    Convert.ToBoolean(row["IS_PRIMARY"].ToString()) == false)
                {
                    string nombreTabla = row["TABLE_NAME"].ToString();
                    string nombreIndice = row["INDEX_NAME"].ToString();
                    bool esUnico = Convert.ToInt32(row["IS_UNIQUE"].ToString()) == 1;

                    CommaDelimitedStringCollection campos = new CommaDelimitedStringCollection();
                    bool indiceEncontrado = false;
                    for (int i = 0; i < numCampos; i++)
                    {
                        if (nombreIndice.Equals(dtNombresCampos.Rows[i]["RDB$INDEX_NAME"].ToString().Trim()))
                        {
                            campos.Add(dtNombresCampos.Rows[i]["RDB$FIELD_NAME"].ToString());
                            indiceEncontrado = true;
                        }
                        else if (indiceEncontrado)
                        {
                            break;
                        }
                    }

                    lista.Add(new TablasIndices(nombreTabla, nombreIndice, campos.ToString(), esUnico));
                }
            }
        }

        #endregion
    }
}
