<?php
/*
  Author: Greg Feigenson
  File: invoice_detail.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/

/*----------------------------------------------------------------------------
  			         Housekeeping, object creation
  ----------------------------------------------------------------------------*/

require('includes/header.inc.php');
require_once("objects/workorder_object.php");

//Grab the workorder id from GET array
$woid = $_GET['invoice'];

//Query for workorders
$query = "SELECT * FROM $view_wo_cust WHERE workorder_id = $woid";

//Connect to db, run query
require("includes/db.inc.php");
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));

//If there's no record of the workorder
if (pg_num_rows($result) < 1)
{
	printNotice("Sorry, no records available for work order $woid");
	require('includes/footer.inc.php');
	exit;
}

//Grab the work order, create a new object
$row = pg_fetch_assoc($result);
$workorder = new workorder($row['start_date'],$row['promised_date'], $row['first_name'], $row['last_name'],$row['phone1'], $row['phone2'], $row['workorder_id'], $row['customer_id']);
$workorder->setStaff($row['staff']);
$workorder->email = $row[email];
$workorder->status = $row[wo_status];

echo "<div align=center>\n";

/*----------------------------------------------------------------------------
  			         Workorders display
  ----------------------------------------------------------------------------*/
  
/* Logo and contact information header */
echo "<table border='0' width='100%' id='table1' height='161'>\n";
echo "\t<tr>\n";
echo "\t\t<td width='250'>\n";
echo "\t\t<img border='0' src='$inv_logo'></td>\n";
echo "\t\t<td>\n";
echo "\t\t<p align='right'>$workorder->first_name $workorder->last_name<br>\n";
echo "\t\t$workorder->phone1<br>\n";
echo "\t\t$row[street1]<br>\n";

if ($row[street2] != "")
	echo "\t\t$row[street2]<br>\n";
	
echo "\t\t$row[city], $row[state], $row[zip]<br>\n";
echo "\t\t$workorder->email</td>\n";
echo "\t\t<td width='34'>\n";
echo "\t\t<p align='right'>&nbsp;</td>\n";
echo "\t</tr>\n";
echo "</table>\n";

/* Header */
echo "<h2><b><u>Workorder $workorder->id</u></h2></b><hr width=35%>\n";

/* Status, staffer and due date */
echo "<u>Info<br>\n";
echo "</u>Due $workorder->due_date</u><br>\n";
echo "Assigned to: $workorder->staff<br>\n";
echo "Status: ".$workorder->highlightStatus($workorder->status)."<br><br>\n";


/* SQL for problems */
$query = "SELECT * FROM $tbl_problems WHERE $tbl_problems.work_order_id = $workorder->id";
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));
$count = pg_num_rows($result);
$i = 1;

/* Workorder Problems */
echo "<u>Issues</u><br>\n";

while ($row = pg_fetch_assoc($result))
{
	echo "<a href='problem_detail.php?problem=$row[problem_id]' target='problems' class='detail'>Issue $i</a>";
	if ($i < $count)
		echo " :: ";

	$i++;
}

echo "<br>\n";
echo "<iframe name='problems' src='problem_detail.php' width='395' height='197'>\n";
echo "Your browser does not support inline frames or is currently configured not to display inline frames.\n";
echo "</iframe></p>\n";

/* SQL for notes */
$query = "SELECT * FROM $tbl_notes WHERE $tbl_notes.work_order_id = $workorder->id";
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));
$count = pg_num_rows($result);
$i = 1;

/* Workorders Notes */
echo "<u>Notes</u><br>\n";

while ($row = pg_fetch_assoc($result))
{
	echo "<a href='note_detail.php?note=$row[note_id]' target='notes' class='detail'>Note $i</a>";
	if ($i < $count)
		echo " :: ";

	$i++;
}

echo "<br>\n";
echo "<iframe name='notes' src='note_detail.php' width='395' height='197'>\n";
echo "Your browser does not support inline frames or is currently configured not to display inline frames.\n";
echo "</iframe>\n";

/* Link back to open workorders */
$backlink = grabLink("open_wo");
echo "<br>\n<br>\n<a href='$backlink[href]'>BACK TO OPEN TICKETS</a>";
echo "</div>";

/* Close DB connection */
pg_close($connection);
require('includes/footer.inc.php');
?>
